/*
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
JFatl.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                              JFatl_Deviation.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 8
//----  
#property indicator_color1  Lime
#property indicator_color2  Lime
#property indicator_color3  Red
#property indicator_color4  Red
#property indicator_color5  Black
#property indicator_color6  BlueViolet
#property indicator_color7  BlueViolet
#property indicator_color8  Black
//----   
#property indicator_width1 5
#property indicator_width2 5 
#property indicator_width3 5
#property indicator_width4 5
#property indicator_width5 5
#property indicator_width6 2 
#property indicator_width7 2
#property indicator_width8 2
//----    
#property indicator_level1   0
#property indicator_level2  50
#property indicator_level3 -50
#property indicator_levelcolor Red
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int Length = 8;   //   
extern int Phase  = 100; // ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//---- 
double Ind_Buffer1 [];
double Ind_Buffer2 [];
double Ind_Buffer3 [];
double Ind_Buffer4 [];
double Ind_Buffer5 [];
double Ind_Buffer6 [];
double Ind_Buffer7 [];
double Ind_Buffer8 [];
int fatl_size=39,INT_point;
//+------------------------------------------------------------------+ 
//| JFatl_Deviation initialization function                          |
//+------------------------------------------------------------------+ 
int init() 
{ 
//----     
SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(4,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(5,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(6,DRAW_HISTOGRAM,STYLE_SOLID);
SetIndexStyle(7,DRAW_HISTOGRAM,STYLE_SOLID);
//---- 8    
SetIndexBuffer(0,Ind_Buffer1);
SetIndexBuffer(1,Ind_Buffer2);
SetIndexBuffer(2,Ind_Buffer3);
SetIndexBuffer(3,Ind_Buffer4);
SetIndexBuffer(4,Ind_Buffer5);
SetIndexBuffer(5,Ind_Buffer6);
SetIndexBuffer(6,Ind_Buffer7);
SetIndexBuffer(7,Ind_Buffer8);
//----   ,       
SetIndexDrawBegin(0,fatl_size+30); 
SetIndexDrawBegin(1,fatl_size+30); 
SetIndexDrawBegin(2,fatl_size+30); 
SetIndexDrawBegin(3,fatl_size+30); 
SetIndexDrawBegin(4,fatl_size+30); 
SetIndexDrawBegin(5,fatl_size+30); 
SetIndexDrawBegin(6,fatl_size+30); 
SetIndexDrawBegin(7,fatl_size+30); 
//----
SetIndexEmptyValue(0,EMPTY_VALUE); 
SetIndexEmptyValue(1,EMPTY_VALUE);
SetIndexEmptyValue(2,EMPTY_VALUE);
SetIndexEmptyValue(3,EMPTY_VALUE);
SetIndexEmptyValue(4,EMPTY_VALUE);
SetIndexEmptyValue(5,EMPTY_VALUE);
SetIndexEmptyValue(6,EMPTY_VALUE);
SetIndexEmptyValue(7,EMPTY_VALUE);
//----
INT_point=1/Point;

IndicatorDigits(0);
//----  
return(0); 
}
//+------------------------------------------------------------------+ 
//| JFatl_Deviation iteration function                               | 
//+------------------------------------------------------------------+  
int start()
   {
//----       
if(Bars-1<=fatl_size)return(0);  
//----      
double JFATL,open,close,high,low,up,down;
//----+        
int limit,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,         
limit=Bars-counted_bars-1; MaxBar=Bars-1-fatl_size;
//----      ,         
//----            
if (limit>=MaxBar)
 {
  for(bar=limit;bar>=MaxBar;bar--)
   {
    Ind_Buffer1[bar]=0;
    Ind_Buffer2[bar]=0;
    Ind_Buffer3[bar]=0;
    Ind_Buffer4[bar]=0;
    Ind_Buffer5[bar]=0;
    Ind_Buffer6[bar]=0;
    Ind_Buffer7[bar]=0;
    Ind_Buffer8[bar]=0;
   }
  limit=MaxBar;
 }
//----+ 
//----+    
for(bar=limit;bar>=0;bar--)
 {
  Ind_Buffer1[bar]=0;
  Ind_Buffer2[bar]=0;
  Ind_Buffer3[bar]=0;
  Ind_Buffer4[bar]=0;
  Ind_Buffer5[bar]=0;
  Ind_Buffer6[bar]=0;
  Ind_Buffer7[bar]=0;
  Ind_Buffer8[bar]=0;
  //----+ 
  JFATL= iCustom(NULL,0,"JFatl",Length,Phase,0,Input_Price_Customs,0,bar);
  //----+ 
  open =Open [bar]-JFATL;
  close=Close[bar]-JFATL;
  high =High [bar]-JFATL;
  low  =Low  [bar]-JFATL; 
  open *=INT_point;
  close*=INT_point;
  high *=INT_point;
  low  *=INT_point; 
      //----+ 
      if (low>0)
       {
        Ind_Buffer6[bar]=high;
        Ind_Buffer8[bar]=low;
       }
      if (high<0)
       {
        Ind_Buffer7[bar]=low;
        Ind_Buffer8[bar]=high;
       }
      if ((low<=0)&&(high>=0))
       {
        Ind_Buffer6[bar]=low;
        Ind_Buffer7[bar]=high;
       }
    //----+ 
    if (open>close)
     {
      if (close>0)
       {
        Ind_Buffer3[bar]=open;
        Ind_Buffer5[bar]=close;
       }
      if (open<0)
       {
        Ind_Buffer4[bar]=close;
        Ind_Buffer5[bar]=open;
       }
      if ((close<=0)&&(open>=0))
       {
        Ind_Buffer3[bar]=open;
        Ind_Buffer4[bar]=close;
       }
      }
    //----+    
    if (open<close)
     {
      if (open>0)
       {
        Ind_Buffer1[bar]=close;
        Ind_Buffer5[bar]=open;
       }
      if (close<0)
       {
        Ind_Buffer2[bar]=open;
        Ind_Buffer5[bar]=close;
       }
      if ((close>=0)&&(open<=0))
       {
        Ind_Buffer1[bar]=close;
        Ind_Buffer2[bar]=open;
       }
     } 
    //----+   
 }
//----    
return(0); 
}
//+------------------------------------------------------------------------------------+